/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.ipc.events;

import com.cisco.pt.UUID;
import com.cisco.pt.impl.IPCEventLTV;
import com.cisco.pt.ipc.events.HTTPClientEvent;
import com.cisco.pt.ipc.events.HTTPClientEventListener;
import com.cisco.pt.ipc.events.IPCEventRegistry;
import com.cisco.pt.ipc.sim.HTTPClient;
import com.cisco.pt.ptmp.PacketTracerSession;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTTPClientEventRegistry
extends IPCEventRegistry {
    protected Set<HTTPClientEventListener> globalListeners = new HashSet<HTTPClientEventListener>();
    protected Map<String, Set<HTTPClientEventListener>> specificObjectListeners = new HashMap<String, Set<HTTPClientEventListener>>();
    private static Log logger = LogFactory.getLog(HTTPClientEventRegistry.class);

    public HTTPClientEventRegistry(PacketTracerSession session) {
        super(session);
    }

    @Override
    public String getClassName() {
        return "HttpClient";
    }

    @Override
    public void processEvent(IPCEventLTV event) throws Exception {
        String eventName = event.getEventName();
        HTTPClientEvent.OnDone evt = null;
        if (!eventName.equalsIgnoreCase("onDone")) {
            logger.info((Object)("Unrecognized eventName for " + this.getClassName() + ": " + eventName));
            return;
        }
        evt = new HTTPClientEvent.OnDone(event);
        for (HTTPClientEventListener listener : this.globalListeners) {
            listener.handleEvent(evt);
        }
        Set<HTTPClientEventListener> specificListeners = this.specificObjectListeners.get(evt.objectUUID.toString());
        if (specificListeners != null) {
            for (HTTPClientEventListener listener : specificListeners) {
                listener.handleEvent(evt);
            }
        }
    }

    public void addListenerFiltered(HTTPClientEventListener listener, List<String> events) throws IOException {
        if (this.globalListeners.size() == 0) {
            if (events == null) {
                this.register("onDone");
            } else {
                for (int i = 0; i < events.size(); ++i) {
                    this.register(events.get(i));
                }
            }
        }
        this.globalListeners.add(listener);
    }

    public void addSpecificListenerFiltered(HTTPClientEventListener listener, HTTPClient objClass, List<String> events) throws IOException {
        UUID uuid = objClass.getObjectUUID();
        String uuidString = uuid.toString();
        Set<HTTPClientEventListener> specificListeners = this.specificObjectListeners.get(uuidString);
        if (specificListeners == null) {
            specificListeners = new HashSet<HTTPClientEventListener>();
            this.specificObjectListeners.put(uuidString, specificListeners);
            if (events == null) {
                this.register(uuid, "onDone");
            } else {
                for (int i = 0; i < events.size(); ++i) {
                    this.register(uuid, events.get(i));
                }
            }
        }
        specificListeners.add(listener);
    }

    public void removeListenerFiltered(HTTPClientEventListener listener, List<String> events) throws IOException {
        if (this.globalListeners.size() != 0) {
            if (events == null) {
                this.deregister("onDone");
            }
            this.globalListeners.remove(listener);
        }
    }

    public void removeSpecificListenerFiltered(HTTPClientEventListener listener, HTTPClient objClass, List<String> events) throws IOException {
        UUID uuid = objClass.getObjectUUID();
        String uuidString = uuid.toString();
        Set<HTTPClientEventListener> specificListeners = this.specificObjectListeners.get(uuidString);
        if (specificListeners != null && !specificListeners.isEmpty()) {
            this.deregister(uuid, "onDone");
            specificListeners.remove(listener);
        }
    }

    public void addListener(HTTPClientEventListener listener) throws IOException {
        this.addListenerFiltered(listener, null);
    }

    public void addListener(HTTPClientEventListener listener, HTTPClient objClass) throws IOException {
        this.addSpecificListenerFiltered(listener, objClass, null);
    }

    public void removeListener(HTTPClientEventListener listener) throws IOException {
        this.removeListenerFiltered(listener, null);
    }

    public void removeListener(HTTPClientEventListener listener, HTTPClient objClass) throws IOException {
        this.removeSpecificListenerFiltered(listener, objClass, null);
    }
}

